//
//  OPGenericCategory.h
//  ApplicationFrameworks
//
//  Created by Rick Fillion on 2015-05-04.
//
//

#import <Foundation/Foundation.h>
#import <OnePasswordCore/OnePasswordCore.h>

@protocol OPGenericProfile;
@class OPCategory;
@class OPTemplate;

@protocol OPGenericCategory <NSObject>

@required

@property (nonatomic, readonly) OPID oid;

@property (nonatomic, copy) NSString * uuid;
@property (nonatomic, copy) NSString * singularName;
@property (nonatomic, copy) NSString * pluralName;
@property (nonatomic, copy) NSString * actionName;
@property (readonly, getter = isSystemCategory) BOOL systemCategory;
@property (readonly, getter = isPremiumCategory) BOOL premiumCategory;
@property (nonatomic) NSUInteger numberOfItems;

@property (nonatomic) BOOL hasCustomIcon;
@property (nonatomic, strong) OPImage * customIcon;

@property (nonatomic, readonly, getter = isHidden) BOOL hidden;
@property (nonatomic, readonly, getter = isAdHoc) BOOL adHoc; // returns YES if this category is only a representation of a category that doesn't actually exist formally.

- (NSString *)localizedSingularName;
- (NSString *)localizedPluralName;
- (NSString *)localizedActionName;
- (NSString *)newItemTitle;

- (OPImage *)sourceIcon;
- (OPImage *)menuIcon;
- (OPImage *)listIcon;
- (OPImage *)detailIcon;

- (NSComparisonResult)compare:(id<OPGenericCategory>)otherCategory; // For purposes of sorting categories.

@end

BOOL OPGenericCategoryIsSystemCategory(NSString *categoryUUID);
NSSet *OPGenericCategoryStandardCategoryUUIDs();
BOOL OPGenericCategoryIsStandardCategory(NSString *categoryUUID);
BOOL OPGenericCategoryIsPremiumCategory(NSString *categoryUUID);

NSString *OPGenericCategoryDefaultSingularName(NSString *categoryUUID);
NSString *OPGenericCategoryDefaultPluralName(NSString *categoryUUID);
NSString *OPGenericCategoryDefaultListIconName(NSString *categoryUUID);
NSString *OPGenericCategoryDefaultDetailIconName(NSString *categoryUUID);
NSUInteger OPGenericCategoryDefaultDisplayOrder(NSString *categoryUUID);
Class OPGenericCategoryItemClassForCategoryUUID(NSString *uuid);
NSComparisonResult OPGenericCategoryCompare(id<OPGenericCategory> category1, id<OPGenericCategory> category2);
NSComparisonResult OPGenericCategoryB5Compare(id<OPGenericCategory> category1, id<OPGenericCategory> category2);

// System Categories
extern NSString * OPCategoryUUIDLogin;
extern NSString * OPCategoryUUIDCreditCard;
extern NSString * OPCategoryUUIDSecureNote;
extern NSString * OPCategoryUUIDIdentity;
extern NSString * OPCategoryUUIDPassword;
extern NSString * OPCategoryUUIDDocument;
extern NSString * OPCategoryUUIDTombstone;
extern NSString * OPCategoryUUIDPurchasePremium;

// Legacy Categories
extern NSString * OPCategoryUUIDSoftwareLicense;
extern NSString * OPCategoryUUIDBankAccount;
extern NSString * OPCategoryUUIDDatabase;
extern NSString * OPCategoryUUIDDriverLicense;
extern NSString * OPCategoryUUIDOutdoorLicense;
extern NSString * OPCategoryUUIDMembership;
extern NSString * OPCategoryUUIDPassport;
extern NSString * OPCategoryUUIDRewards;
extern NSString * OPCategoryUUIDSocialSecurityNumber;
extern NSString * OPCategoryUUIDRouter;
extern NSString * OPCategoryUUIDServer;
extern NSString * OPCategoryUUIDEmail;
